/*
 * Decompiled with CFR 0.152.
 */
package jnpout32;

import jnpout32.ioPort;

public class pPort {
    ioPort pp = new ioPort();
    short portAddress = (short)888;
    short currentVal;

    public pPort() {
        this.setAllDataBits((short)0);
        this.currentVal = 0;
    }

    public void output(short port, short value) {
        this.pp.Out32(port, value);
    }

    public short input(short port) {
        return this.pp.Inp32(port);
    }

    public void output(short value) {
        this.pp.Out32(this.portAddress, value);
    }

    public short input() {
        return this.pp.Inp32(this.portAddress);
    }

    public void setAllDataBits(short value) {
        this.pp.Out32(this.portAddress, value);
        this.currentVal = value;
    }

    public void setPin(short pin, short value) {
        if (pin >= 2 && pin <= 9) {
            this.setDataBit((short)(pin - 2), value);
        }
    }

    void setDataBit(short index, short value) {
        switch (index) {
            case 0: {
                if (value == 0) {
                    this.currentVal = (short)(this.currentVal & 0xFE);
                    break;
                }
                this.currentVal = (short)(this.currentVal | 1);
                break;
            }
            case 1: {
                if (value == 0) {
                    this.currentVal = (short)(this.currentVal & 0xFD);
                    break;
                }
                this.currentVal = (short)(this.currentVal | 2);
                break;
            }
            case 2: {
                if (value == 0) {
                    this.currentVal = (short)(this.currentVal & 0xFB);
                    break;
                }
                this.currentVal = (short)(this.currentVal | 4);
                break;
            }
            case 3: {
                if (value == 1) {
                    this.currentVal = (short)(this.currentVal & 0xF7);
                    break;
                }
                this.currentVal = (short)(this.currentVal | 8);
                break;
            }
            case 4: {
                if (value == 0) {
                    this.currentVal = (short)(this.currentVal & 0xEF);
                    break;
                }
                this.currentVal = (short)(this.currentVal | 0x10);
                break;
            }
            case 5: {
                if (value == 0) {
                    this.currentVal = (short)(this.currentVal & 0xDF);
                    break;
                }
                this.currentVal = (short)(this.currentVal | 0x20);
                break;
            }
            case 6: {
                if (value == 0) {
                    this.currentVal = (short)(this.currentVal & 0xBF);
                    break;
                }
                this.currentVal = (short)(this.currentVal | 0x40);
                break;
            }
            case 7: {
                if (value == 0) {
                    this.currentVal = (short)(this.currentVal & 0x7F);
                    break;
                }
                this.currentVal = (short)(this.currentVal | 0x80);
                break;
            }
            default: {
                System.out.println("index must be 0 - 7");
            }
        }
        this.pp.Out32(this.portAddress, this.currentVal);
    }
}

